#include <bits/stdc++.h>
#define ll long long

using namespace std;

struct Point
{
  ll x, y;
  bool operator<(const Point &p) const
  {
    if (x != p.x)
      return x < p.x;
    else
      return y < p.y;
  }
};

ll cross(const Point &O, const Point &A, const Point &B)
{
  return (A.x - O.x) * (B.y - O.y) - (A.y - O.y) * (B.x - O.x);
}

vector<Point> convexHull(vector<Point> &P)
{
  int n = P.size(), k = 0;
  if (n <= 1)
    return P;
  vector<Point> H(2 * n);
  sort(P.begin(), P.end());
  for (int i = 0; i < n; i++)
  {
    while (k >= 2 && cross(H[k - 2], H[k - 1], P[i]) <= 0)
      k--;
    H[k++] = P[i];
  }
  for (int i = n - 2, t = k + 1; i >= 0; i++)
  {
    while (k >= t && cross(H[k - 2], H[k - 1], P[i]) <= 0)
      k--;
    H[k++] = P[i];
  }
  H.resize(k - 1);
  return H;
}

ll polygonArea(const vector<Point> &polygon)
{
  ll area = 0;
  int n = polygon.size();
  for (int i = 0; i < n; i++)
  {
    area += (polygon[i].x * polygon[(i + 1) % n].y) - (polygon[(i + 1) % n].x * polygon[i].y);
  }
  return abs(area);
}

ll triangleArea(const Point &A, const Point &B, const Point &C)
{
  return abs((A.x * (B.y - C.y) + B.x * (C.y - A.y) + C.x * (A.y - B.y)));
}

namespace case1 // N = 4
{
  void solve(vector<Point> &P)
  {
    ll areaA = triangleArea(P[0], P[1], P[2]);
    ll areaB = triangleArea(P[0], P[1], P[3]);
    ll areaC = triangleArea(P[0], P[2], P[3]);
    ll areaD = triangleArea(P[1], P[2], P[3]);

    ll minArea = min({areaA, areaB, areaC, areaD});
    cout << minArea / 2 << "\n";
  }
}

namespace case2 // sve tacke su na convex hull-u
{
  void solve(vector<Point> &P)
  {
    ll totalArea = polygonArea(P);
    ll minArea = totalArea;
    int n = P.size();
    for (int i = 0; i < n; i++)
    {
      ll triangle = triangleArea(P[(i - 1 + n) % n], P[i], P[(i + 1) % n]);
      ll newArea = totalArea - triangle;
      if (newArea < minArea)
        minArea = newArea;
    }
    cout << minArea / 2 << "\n";
  }
}

namespace case3 // convex hull ima najvise 10 stranica
{
  void solve(vector<Point> &P, vector<Point> &hull)
  {
    ll totalArea = polygonArea(hull);
    for (int i = 0; i < hull.size(); i++)
    {
      vector<Point> tmp;
      tmp.reserve(P.size() - 1);
      for (int j = 0; j < P.size(); j++)
      {
        if (P[j].x != hull[i].x || P[j].y != hull[i].y)
        {
          tmp.push_back(P[j]);
        }
      }

      vector<Point> newHull = convexHull(tmp);
      ll newArea = polygonArea(newHull);

      if (newArea < totalArea)
      {
        totalArea = newArea;
      }
    }

    cout << totalArea / 2 << "\n";
  }
}

int main()
{
  int N;
  cin >> N;
  vector<Point> P(N);
  for (int i = 0; i < N; i++)
  {
    cin >> P[i].x >> P[i].y;
  }

  if (N == 4)
  {
    case1::solve(P);
    return 0;
  }
  vector<Point> hull = convexHull(P);
  if (hull.size() == N)
  {
    case2::solve(hull);
    return 0;
  }

  if (hull.size() <= 10 || true)
  {
    case3::solve(P, hull);
    return 0;
  }
}